/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.common.item;

import com.agricraft.agricraft.api.AgriApi;
import com.agricraft.agricraft.api.config.CoreConfig;
import com.agricraft.agricraft.api.crop.AgriCrop;
import com.agricraft.agricraft.api.genetic.AgriGenome;
import com.agricraft.agricraft.api.genetic.AgriGenomeProviderItem;
import com.agricraft.agricraft.api.stat.AgriStat;
import com.agricraft.agricraft.api.stat.AgriStatRegistry;
import com.agricraft.agricraft.common.block.CropBlock;
import com.agricraft.agricraft.common.block.CropState;
import com.agricraft.agricraft.common.item.AgriSeedItem;
import com.agricraft.agricraft.common.registry.ModBlocks;
import com.agricraft.agricraft.common.util.LangUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import org.jetbrains.annotations.Nullable;

public class SeedBagItem
extends class_1792 {
    public static final List<BagSorter> SORTERS = new ArrayList<BagSorter>();
    public static final BagSorter DEFAULT_SORTER = new BagSorter(){

        @Override
        public class_2960 getId() {
            return new class_2960("agricraft", "default");
        }

        @Override
        public int compare(BagEntry entry1, BagEntry entry2) {
            int s2;
            int s1 = AgriStatRegistry.getInstance().stream().mapToInt(stat -> entry1.genome.getStatGene((AgriStat)stat).getTrait()).sum();
            if (s1 != (s2 = AgriStatRegistry.getInstance().stream().mapToInt(stat -> entry2.genome.getStatGene((AgriStat)stat).getTrait()).sum())) {
                return s2 - s1;
            }
            return AgriStatRegistry.getInstance().stream().mapToInt(stat -> {
                Integer d1 = entry1.genome.getStatGene((AgriStat)stat).getDominant().trait();
                Integer r1 = entry1.genome.getStatGene((AgriStat)stat).getRecessive().trait();
                Integer d2 = entry2.genome.getStatGene((AgriStat)stat).getDominant().trait();
                Integer r2 = entry2.genome.getStatGene((AgriStat)stat).getRecessive().trait();
                return d2 + r2 - (d1 + r1);
            }).sum();
        }
    };

    public SeedBagItem(class_1792.class_1793 properties) {
        super(properties);
    }

    public static void addStatSorter(AgriStat stat) {
        SORTERS.add(new StatSorter(stat));
    }

    private static boolean plantOnCrop(AgriCrop crop, class_1799 seed) {
        if (crop.hasPlant() || crop.isCrossCropSticks()) {
            return false;
        }
        crop.plantGenome(AgriGenome.fromNBT(seed.method_7969()));
        return true;
    }

    public static int add(class_1799 seedBag, class_1799 insertedStack) {
        class_1792 class_17922;
        if (insertedStack.method_7960() || !((class_17922 = insertedStack.method_7909()) instanceof AgriGenomeProviderItem)) {
            return 0;
        }
        AgriGenomeProviderItem seed = (AgriGenomeProviderItem)class_17922;
        class_2487 tag = seedBag.method_7948();
        Optional<AgriGenome> opt = seed.getGenome(insertedStack);
        if (opt.isEmpty()) {
            return 0;
        }
        AgriGenome genome = opt.get();
        if (tag.method_10545("species") && !genome.getSpeciesGene().getTrait().equals(tag.method_10558("species"))) {
            return 0;
        }
        if (!tag.method_10545("seeds")) {
            tag.method_10566("seeds", (class_2520)new class_2499());
            tag.method_10582("species", genome.getSpeciesGene().getTrait());
        }
        class_2499 seeds = tag.method_10554("seeds", 10);
        int size = SeedBagItem.size(seedBag);
        if (size >= CoreConfig.seedBagCapacity) {
            return 0;
        }
        class_2487 seedTag = new class_2487();
        int insertedCount = Math.min(CoreConfig.seedBagCapacity - size, insertedStack.method_7947());
        seedTag.method_10569("count", insertedCount);
        genome.writeToNBT(seedTag);
        seeds.add((Object)seedTag);
        SeedBagItem.sort(seedBag);
        return insertedCount;
    }

    public static class_1799 extractFirstStack(class_1799 seedBag) {
        class_2499 seeds = seedBag.method_7969().method_10554("seeds", 10);
        BagEntry entry = BagEntry.fromNBT(seeds.method_10602(0));
        class_1799 seed = AgriSeedItem.toStack(entry.genome);
        seed.method_7939(entry.count);
        seeds.method_10536(0);
        if (seeds.isEmpty()) {
            seedBag.method_7969().method_10551("seeds");
            seedBag.method_7969().method_10551("species");
        }
        return seed;
    }

    public static class_1799 extractFirstItem(class_1799 seedBag, boolean simulate) {
        class_2499 seeds = seedBag.method_7969().method_10554("seeds", 10);
        class_2487 seedTag = seeds.method_10602(0);
        AgriGenome genome = AgriGenome.fromNBT(seedTag);
        class_1799 seed = AgriSeedItem.toStack(genome);
        if (!simulate) {
            int count = seedTag.method_10550("count") - 1;
            seedTag.method_10569("count", count);
            if (count <= 0) {
                seeds.method_10536(0);
            }
            if (seeds.isEmpty()) {
                seedBag.method_7969().method_10551("seeds");
                seedBag.method_7969().method_10551("species");
            }
        }
        return seed;
    }

    public static void changeSorter(class_1799 seedBag, int delta) {
        if (delta == 0) {
            return;
        }
        class_2487 tag = seedBag.method_7948();
        int sorterIndex = 0;
        if (tag.method_10545("sorter")) {
            sorterIndex = tag.method_10550("sorter");
        }
        if ((sorterIndex += delta) < 0) {
            sorterIndex += SORTERS.size();
        }
        tag.method_10569("sorter", sorterIndex %= SORTERS.size());
        SeedBagItem.sort(seedBag);
    }

    private static void sort(class_1799 seedBag) {
        class_2487 tag = seedBag.method_7948();
        int sorterIndex = 0;
        if (tag.method_10545("sorter")) {
            sorterIndex = tag.method_10550("sorter");
        }
        class_2499 listTag = tag.method_10554("seeds", 10);
        ArrayList<BagEntry> entries = new ArrayList<BagEntry>();
        for (int i = 0; i < listTag.size(); ++i) {
            entries.add(BagEntry.fromNBT(listTag.method_10602(i)));
        }
        BagSorter sorter = SORTERS.get(sorterIndex);
        entries.sort(sorter);
        listTag.clear();
        for (BagEntry entry : entries) {
            class_2487 t = new class_2487();
            entry.writeToNBT(t);
            listTag.add((Object)t);
        }
    }

    public static int size(class_1799 seedBag) {
        class_2487 tag = seedBag.method_7969();
        if (tag == null || !tag.method_10545("seeds")) {
            return 0;
        }
        class_2499 seeds = tag.method_10554("seeds", 10);
        int count = 0;
        for (int i = 0; i < seeds.size(); ++i) {
            count += seeds.method_10602(i).method_10550("count");
        }
        return count;
    }

    public static boolean isEmpty(class_1799 stack) {
        class_2487 tag = stack.method_7969();
        return tag == null || !tag.method_10545("species");
    }

    public static boolean isFilled(class_1799 stack) {
        class_2487 tag = stack.method_7969();
        return tag != null && tag.method_10545("seeds") && SeedBagItem.size(stack) == CoreConfig.seedBagCapacity;
    }

    private static void playRemoveOneSound(class_1297 entity) {
        entity.method_5783(class_3417.field_34377, 0.8f, 0.8f + entity.method_37908().method_8409().method_43057() * 0.4f);
    }

    private static void playInsertSound(class_1297 entity) {
        entity.method_5783(class_3417.field_34376, 0.8f, 0.8f + entity.method_37908().method_8409().method_43057() * 0.4f);
    }

    public class_1269 method_7884(class_1838 context) {
        if (context.method_20287() == class_1268.field_5810) {
            return super.method_7884(context);
        }
        class_1799 seedBag = context.method_8041();
        if (SeedBagItem.isEmpty(seedBag)) {
            return class_1269.field_5811;
        }
        class_1937 level = context.method_8045();
        class_1799 seed = SeedBagItem.extractFirstItem(seedBag, true);
        class_2338 pos = context.method_8037();
        Optional<AgriCrop> optional = AgriApi.getCrop((class_1922)level, pos);
        if (optional.isPresent()) {
            if (SeedBagItem.plantOnCrop(optional.get(), seed)) {
                SeedBagItem.extractFirstItem(seedBag, false);
                return class_1269.field_5812;
            }
            return class_1269.field_5811;
        }
        optional = AgriApi.getCrop((class_1922)level, pos.method_10084());
        if (optional.isPresent()) {
            if (SeedBagItem.plantOnCrop(optional.get(), seed)) {
                SeedBagItem.extractFirstItem(seedBag, false);
                return class_1269.field_5812;
            }
            return class_1269.field_5811;
        }
        if (CoreConfig.plantOffCropSticks && AgriApi.getSoil(level, pos).isPresent() && level.method_8320(pos.method_10084()).method_26215()) {
            level.method_8652(pos.method_10084(), (class_2680)((class_2248)ModBlocks.CROP.get()).method_9564().method_11657(CropBlock.CROP_STATE, (Comparable)((Object)CropState.PLANT)), 11);
            optional = AgriApi.getCrop((class_1922)level, pos.method_10084());
            if (optional.isPresent()) {
                optional.get().plantGenome(AgriGenome.fromNBT(seed.method_7969()), (class_1309)context.method_8036());
                SeedBagItem.extractFirstItem(seedBag, false);
                return class_1269.field_5812;
            }
            return class_1269.field_5811;
        }
        return class_1269.field_5811;
    }

    public boolean method_31565(class_1799 seedBag, class_1735 slot, class_5536 action, class_1657 player) {
        if (seedBag.method_7947() == 1 && action == class_5536.field_27014) {
            class_1799 itemStack = slot.method_7677();
            if (itemStack.method_7960()) {
                if (!SeedBagItem.isEmpty(seedBag)) {
                    SeedBagItem.playRemoveOneSound((class_1297)player);
                    class_1799 seed = SeedBagItem.extractFirstStack(seedBag);
                    slot.method_32756(seed);
                }
            } else if (itemStack.method_7909().method_31568()) {
                int inserted = SeedBagItem.add(seedBag, itemStack);
                slot.method_32753(itemStack.method_7947(), inserted, player);
                if (inserted > 0) {
                    SeedBagItem.playInsertSound((class_1297)player);
                }
            }
            return true;
        }
        return false;
    }

    public boolean method_31566(class_1799 seedBag, class_1799 other, class_1735 slot, class_5536 action, class_1657 player, class_5630 access) {
        if (seedBag.method_7947() == 1 && action == class_5536.field_27014 && slot.method_32754(player)) {
            int inserted;
            if (other.method_7960()) {
                if (!SeedBagItem.isEmpty(seedBag)) {
                    SeedBagItem.playRemoveOneSound((class_1297)player);
                    class_1799 seed = SeedBagItem.extractFirstStack(seedBag);
                    access.method_32332(seed);
                }
            } else if (other.method_7909().method_31568() && (inserted = SeedBagItem.add(seedBag, other)) > 0) {
                SeedBagItem.playInsertSound((class_1297)player);
                other.method_7934(inserted);
            }
            return true;
        }
        return false;
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 level, List<class_2561> tooltipComponents, class_1836 isAdvanced) {
        if (SeedBagItem.isEmpty(stack)) {
            tooltipComponents.add((class_2561)class_2561.method_43471((String)"agricraft.tooltip.bag.empty").method_27692(class_124.field_1063));
        } else {
            tooltipComponents.add((class_2561)class_2561.method_43469((String)"agricraft.tooltip.bag.content", (Object[])new Object[]{SeedBagItem.size(stack)}).method_10852(LangUtils.seedName(stack.method_7969().method_10558("species"))).method_27692(class_124.field_1063));
        }
        int i = stack.method_7948().method_10550("sorter");
        String id = SORTERS.get(i).getId().toString().replace(":", ".");
        tooltipComponents.add((class_2561)class_2561.method_43471((String)"agricraft.tooltip.bag.sorter").method_10852((class_2561)class_2561.method_43471((String)("agricraft.tooltip.bag.sorter." + id))).method_27692(class_124.field_1063));
    }

    static {
        SORTERS.add(DEFAULT_SORTER);
    }

    public static class StatSorter
    implements BagSorter {
        private final AgriStat stat;
        private final class_2960 id;

        public StatSorter(AgriStat stat) {
            this.stat = stat;
            this.id = new class_2960("agricraft", stat.getId());
        }

        @Override
        public class_2960 getId() {
            return this.id;
        }

        @Override
        public int compare(BagEntry entry1, BagEntry entry2) {
            int s2;
            int s1 = entry1.genome.getStatGene(this.stat).getTrait();
            if (s1 == (s2 = entry2.genome.getStatGene(this.stat).getTrait().intValue())) {
                return DEFAULT_SORTER.compare(entry1, entry2);
            }
            return s2 - s1;
        }
    }

    public record BagEntry(int count, AgriGenome genome) {
        public static BagEntry fromNBT(class_2487 tag) {
            return new BagEntry(tag.method_10550("count"), AgriGenome.fromNBT(tag));
        }

        public void writeToNBT(class_2487 tag) {
            tag.method_10569("count", this.count);
            this.genome.writeToNBT(tag);
        }
    }

    public static interface BagSorter
    extends Comparator<BagEntry> {
        public class_2960 getId();
    }
}

